/*-----------------------------------------------------------------------*
  Project: godray
  File: godray.ps

  Copyright (C) 2011 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo and/or its licensed developers
  and are protected by national and international copyright laws. They
  may not be disclosed to third parties or copied or duplicated in any
  form, in whole or in part, without the prior written consent of
  Nintendo.

  The content herein is highly confidential and should be handled
  accordingly.
*-----------------------------------------------------------------------*/
varying vec2 v_texcoord;

const float     fGodRaysSamples = 8.0;

uniform sampler2D   s_tex0;

uniform vec4        godrayParams0;
uniform vec4        godrayParams1;
uniform vec4        godrayParams2;
uniform vec4        godrayParams3;
uniform vec2        godrayCenter;

uniform vec4 u_blendcolor;

vec2 getDirection( vec2 texcoord)
{
    float   sample = fGodRaysSamples;

    vec2    spos = godrayCenter.xy;
    vec2    dir = ( spos - texcoord );
    if (spos.x < 0.0)
    {
		float t = (0.0 - texcoord.x) / dir.x;
        spos.x = 0.0;
        spos.y = texcoord.y + dir.y * t;
    }
    if (spos.x > 1.0)
    {
        float t = (1.0 - texcoord.x) / dir.x;
        spos.x = 1.0;
        spos.y = texcoord.y + dir.y * t;
    }
    dir = ( spos - texcoord );

    if (spos.y < 0.0)
    {
        float t = (0.0 - texcoord.y) / dir.y;
        spos.y = 0.0;
        spos.x = texcoord.x + dir.x * t;
    }
    if (spos.y > 1.0)
    {
        float t = (1.0 - texcoord.y) / dir.y;
        spos.y = 1.0;
        spos.x = texcoord.x + dir.x * t;
    }
    dir = ( spos - texcoord ) / sample;

    return  dir;
}

void main()
{
    vec2    dir = getDirection( v_texcoord);

    vec4    dest_color = vec4(0,0,0,0);
    dest_color += texture2D( s_tex0, v_texcoord + dir * godrayParams0.x)
                * godrayParams0.y;
    dest_color += texture2D( s_tex0, v_texcoord + dir * godrayParams0.z)
                * godrayParams0.w;

    dest_color += texture2D( s_tex0, v_texcoord + dir * godrayParams1.x)
                * godrayParams1.y;
    dest_color += texture2D( s_tex0, v_texcoord + dir * godrayParams1.z)
                * godrayParams1.w;

    dest_color += texture2D( s_tex0, v_texcoord + dir * godrayParams2.x)
                * godrayParams2.y;
    dest_color += texture2D( s_tex0, v_texcoord + dir * godrayParams2.z)
                * godrayParams2.w;

    dest_color += texture2D( s_tex0, v_texcoord + dir * godrayParams3.x)
                * godrayParams3.y;
    dest_color += texture2D( s_tex0, v_texcoord + dir * godrayParams3.z)
                * godrayParams3.w;

    gl_FragColor = dest_color;
}
